let objects = require('common/objects');
let $$ = require('./utils/debug');
let call = require('./utils/call');

module.exports = (id, trace) => {
  let obj = objects.tryFind(id);
  let script = obj ? obj.name.replace('.js', '') : id;
  let package = obj ? require('./utils/package')(id) : 'console';
  let print = $$.print;

  // DEBUG closure function to reference local objects in this scope
  return function (_tag) {
    let that = this;
    let start = 0;
    // TODO: check if that is a token object and handle workflow debug output
    if (that && that.$$ && that.$$.environment.debug === false) return;

    let args = [];
    if (package && package.name) {
      args.push(package.name);
      args.push('-');
    }

    if (trace) {
      let caller = call.stack()[1];
      script = caller.module.replace('.js', '').replace('<cmd>', 'console');
      let where = typeof caller.function !== 'undefined' ? caller.function : caller.line;
      script = script + '[' + where + ']';
    }
    args.push(script);
    // process tag shortcuts to replace DEBUG('tag', tag) => DEBUG('*tag')
    // TODO: process nested object tags
    if (_tag && typeof _tag === 'string' && _tag.length > 1 && _tag[0] === '*' && _tag.slice(1) in that) {
      start = 1;
      args.push('-');
      args.push(_tag.slice(1));
      // args.push('-');
      args.push(that[_tag.slice(1)]);
    }
    for (let i = start; i < arguments.length; i++) args.push(arguments[i]);
    print.apply(print, args);
  };
};
